<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\Model;

/**
 * Class ColorAssets
 * @package LifeStyle\TemplateBundle\Model
 */
class ColorAssets
{
    /**
     * @var string
     */
    private $baseColorDark = '';

    /**
     * @var string
     */
    private $baseColorLight = '';

    /**
     * @var array
     */
    private $mapperArray = [
        'base_color_dark' => 'baseColorDark',
        'base_color_light' => 'baseColorLight'
    ];

    /**
     * ColorAssets constructor.
     * @param array $configArray
     */
    public function __construct(array $configArray)
    {
        foreach ($this->mapperArray as $item => $value){
            $this->{$value} = $configArray[$item];
        }
    }

    /**
     * @return string
     */
    public function getBaseColorDark(): string
    {
        return $this->baseColorDark;
    }

    /**
     * @return string
     */
    public function getBaseColorLight(): string
    {
        return $this->baseColorLight;
    }
}