<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\Model;

/**
 * Class TextAssets
 * @package LifeStyle\TemplateBundle\Model
 */
class TextAssets
{
    /**
     * @var string
     */
    private $companyName = '';

    /**
     * @var array
     */
    private $mapperArray = [
        'company_name' => 'companyName'
    ];

    /**
     * ColorAssets constructor.
     * @param array $configArray
     */
    public function __construct(array $configArray)
    {
        foreach ($this->mapperArray as $item => $value) {
            $this->{$value} = $configArray[$item];
        }
    }

    /**
     * @return string
     */
    public function getCompanyName(): string
    {
        return $this->companyName;
    }
}