<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\Tests\Model;

use LifeStyle\TemplateBundle\Model\ColorAssets;
use PHPUnit\Framework\TestCase;

/**
 * Class ColorAssets
 * @package LifeStyle\TemplateBundle\Model
 */
class ColorAssetsTest extends TestCase
{
    /**
     * test getter
     */
    public function testModel()
    {
        $configArray = [
            'base_color_dark' => 'test',
            'base_color_light' => 'test1'
        ];
        $model = new ColorAssets($configArray);

        $this->assertEquals('test', $model->getBaseColorDark());
        $this->assertEquals('test1', $model->getBaseColorLight());
    }
}