<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\TemplateBundle\Twig\Extension;

use LifeStyle\TemplateBundle\Model\ColorAssets;
use LifeStyle\TemplateBundle\Model\ImageAssets;
use LifeStyle\TemplateBundle\Model\TextAssets;

/**
 * Class Template
 * @package LifeStyle\TemplateBundle\Twig\Extension
 */
class Template extends \Twig_Extension implements \Twig_Extension_GlobalsInterface
{
    /**
     * @var ColorAssets
     */
    private $colorAssets;

    /**
     * @var ImageAssets
     */
    private $imageAssets;

    /**
     * @var TextAssets
     */
    private $textAssets;

    /**
     * Template constructor.
     * @param ColorAssets $colorAssets
     * @param ImageAssets $imageAssets
     * @param TextAssets $textAssets
     */
    public function __construct(ColorAssets $colorAssets, ImageAssets $imageAssets, TextAssets $textAssets)
    {
        $this->colorAssets = $colorAssets;
        $this->imageAssets = $imageAssets;
        $this->textAssets = $textAssets;
    }

    /**
     * Get extension-name
     *
     * @return string
     */
    public function getName()
    {
        return 'life-style-template-extension';
    }

    /**
     * Get global variables
     *
     * @return array
     */
    public function getGlobals()
    {
        return array(
            'lsColorAssets' => $this->getColorAssets(),
            'lsImageAssets' => $this->getImageAssets(),
            'lsTextAssets' => $this->getTextAssets()
        );
    }

    /**
     * @return ColorAssets
     */
    public function getColorAssets(): ColorAssets
    {
        return $this->colorAssets;
    }

    /**
     * @return ImageAssets
     */
    public function getImageAssets(): ImageAssets
    {
        return $this->imageAssets;
    }

    /**
     * @return TextAssets
     */
    public function getTextAssets(): TextAssets
    {
        return $this->textAssets;
    }
}
