<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CipheringBundle\Api\Ciphering;

use LifeStyle\Tools\CipheringBundle\Api\Manager as CipheringApiManager;

/**
 * Class Factory
 * @package LifeStyle\Tools\CipheringBundle\Api\Ciphering
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var CipheringApiManager
     */
    protected $cipheringApiM;

    /**
     * Factory constructor.
     * @param CipheringApiManager $cipheringApiManager
     */
    public function __construct(CipheringApiManager $cipheringApiManager)
    {
        $this->cipheringApiM = $cipheringApiManager;
    }

    /**
     * @return Encoder\Index
     */
    public function encoder()
    {
        if (!isset($this->facSetter['encoder'])) {
            $this->facSetter['encoder'] = new Encoder\Index($this->encryptionDetector(), $this->configuration());
        }

        return $this->facSetter['encoder'];
    }

    /**
     * @return Configuration\EncryptionDetector;
     */
    public function encryptionDetector()
    {
        if (!isset($this->facSetter['encryptionDetector'])) {
            $this->facSetter['encryptionDetector'] = new Configuration\EncryptionDetector($this->cipheringApiM->getContainer()->get('request_stack'), $this->configuration());
        }

        return $this->facSetter['encryptionDetector'];
    }

    /**
     * @return Configuration\Index
     */
    public function configuration()
    {
        if (!isset($this->facSetter['configuration'])) {
            $this->facSetter['configuration'] = new Configuration\Index($this->cipheringApiM->getContainer());
        }

        return $this->facSetter['configuration'];
    }

    /**
     * @return Decoder\Index
     */
    public function decoder()
    {
        if (!isset($this->facSetter['decoder'])) {
            $this->facSetter['decoder'] = new Decoder\Index($this->encryptionDetector(), $this->configuration());
        }

        return $this->facSetter['decoder'];
    }
}
