<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CipheringBundle\Api;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Manager
 * @package LifeStyle\Tools\CipheringBundle\Api
 */
class Manager
{
    /**
     * @var Container
     */
    public $container;

    /**
     * List of this factories
     * @var array
     */
    protected $factory;

    /**
     * Manager constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return Ciphering\Factory
     */
    public function ciphering()
    {
        if (!isset($this->factory['ciphering'])) {
            $this->factory['ciphering'] = new Ciphering\Factory($this);
        }
        return $this->factory['ciphering'];
    }

    /**
     * @return Container
     */
    public function getContainer()
    {
        return $this->container;
    }
}
