<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\CipheringBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
// these import the "@Route" and "@Template" annotations
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use JMS\SecurityExtraBundle\Annotation\Secure;

/**
 * Class TestController
 * @package LifeStyle\Tools\CipheringBundle\Controller
 */
class TestController extends Controller
{
    /**
     * @param Request $request
     * @Route("/encode", name="life_style_tools_ciphering_test_encode")
     * @Template()
     * @Secure(roles="ROLE_SUPER_ADMIN")
     * @return array
     */
    public function encodeAction(Request $request)
    {
        $form = $this->createFormBuilder()
            ->add('flexEncryptionKey', 'text')
            ->add('data', 'textarea')
            ->add('encode data', 'submit')
            ->getForm();

        $form->handleRequest($request);

        $encodedData = "";

        if ($form->isValid()) {

            $formArray = $form->getData();
            $key = $formArray['flexEncryptionKey'];
            $data = $formArray['data'];
            $apiM = $this->get('ciphering_api_manager');
            $encodedData = $apiM->ciphering()->encoder()->encode($data, $key);
        }

        return ['form' => $form->createView(),'encodedData' => $encodedData];
    }

    /**
     *
     * @Secure(roles="ROLE_SUPER_ADMIN")
     *
     * @Route("/decode", name="life_style_tools_ciphering_test_decode")
     * @Template()
     */
    public function decodeAction(Request $request)
    {
        $form = $this->createFormBuilder()
            ->add('flexEncryptionKey', 'text')
            ->add('data', 'textarea')
            ->add('decode data', 'submit')
            ->getForm();

        $form->handleRequest($request);

        $decodedData = "";

        if ($form->isValid()) {

            $formArray = $form->getData();
            $key = $formArray['flexEncryptionKey'];
            $data = $formArray['data'];
            $apiM = $this->get('ciphering_api_manager');
            $decodedData = $apiM->ciphering()->decoder()->decode($data, $key);
        }

        return ['form' => $form->createView(),'decodedData' => $decodedData];
    }
}
