<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Api\Mfa\Configuration;

use LifeStyle\Tools\MfaBundle\Api\Manager as MfaApiManager;

/**
 * Class Index
 * @package LifeStyle\Tools\MfaBundle\Api\Mfa\Create
 */
class Index
{
    /**
     * secretLength
     * must be a multiple of 8 mit 16
     * @var integer
     */
    protected $secretLength = 40;

    /**
     * keyLength
     *
     * @var integer
     */
    protected $keyLength = 6;

    /**
     * seconds
     *
     * @var integer = 30
     */
    protected $period = 30;

    /**
     * for key
     * @var integer|null
     */
    protected $offset = null;

    /**
     * @var MfaApiManager
     */
    protected $mfaApiM;

    /**
     * @var string
     */
    protected $base32Map;

    /**
     * Factory constructor.
     * @param MfaApiManager $mfaApiManager
     */
    public function __construct(MfaApiManager $mfaApiManager)
    {
        $this->mfaApiManager = $mfaApiManager;
        $this->base32Map = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567';
    }

    /**
     * @return int
     */
    public function getSecretLength()
    {
        return $this->secretLength;
    }

    /**
     * @param int $secretLength
     * @return Index
     */
    public function setSecretLength($secretLength)
    {
        $this->secretLength = $secretLength;

        return $this;
    }

    /**
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int|null $offset
     * @return Index
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getPeriod()
    {
        return $this->period;
    }

    /**
     * @param int $period
     * @return Index
     */
    public function setPeriod($period)
    {
        $this->period = $period;

        return $this;
    }

    /**
     * @return int
     */
    public function getKeyLength()
    {
        return $this->keyLength;
    }

    /**
     * @param int $keyLength
     * @return Index
     */
    public function setKeyLength($keyLength)
    {
        $this->keyLength = $keyLength;

        return $this;
    }

    /**
     * @return string
     */
    public function getBase32Map()
    {
        return $this->base32Map;
    }
}
