<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Api\Mfa;

use LifeStyle\Tools\MfaBundle\Api\Manager as MfaApiManager;

/**
 * Class Factory
 * @package LifeStyle\Tools\CipheringBundle\Api\Ciphering
 */
class Factory
{

    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var MfaApiManager
     */
    protected $mfaApiM;

    /**
     * Factory constructor.
     * @param MfaApiManager $mfaApiM
     */
    public function __construct(MfaApiManager $mfaApiM)
    {
        $this->mfaApiM = $mfaApiM;
    }

    /**
     * @return Validate\Index
     */
    public function validate()
    {
        if (!isset($this->facSetter['validate'])) {
            $this->facSetter['validate'] = new Validate\Index($this->mfaApiM);
        }

        return $this->facSetter['validate'];
    }

    /**
     * @return Create\Index
     */
    public function create()
    {
        if (!isset($this->facSetter['create'])) {
            $this->facSetter['create'] = new Create\Index($this->mfaApiM);
        }

        return $this->facSetter['create'];
    }

    /**
     * @return Image\Index
     */
    public function image()
    {
        if (!isset($this->facSetter['image'])) {
            $this->facSetter['image'] = new Image\Index($this->otpAuth());
        }

        return $this->facSetter['image'];
    }

    /**
     * @return OtpAuth\Index
     */
    public function otpAuth()
    {
        if (!isset($this->facSetter['otpAuth'])) {
            $this->facSetter['otpAuth'] = new OtpAuth\Index($this->mfaApiM->getContainer()->getParameter('kernel.environment'));
        }

        return $this->facSetter['otpAuth'];
    }

    /**
     * @return Configuration\Index
     */
    public function configuration()
    {
        if (!isset($this->facSetter['configuration'])) {
            $this->facSetter['configuration'] = new Configuration\Index($this->mfaApiM);
        }

        return $this->facSetter['configuration'];
    }
}
