<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Api\Mfa\OtpAuth;

/**
 * Class Index
 * @package LifeStyle\Tools\MfaBundle\Api\Mfa\OtpAuth
 */
class Index
{
    /**
     * @var string
     */
    private $environment;

    /**
     * Index constructor.
     * @param string $environment
     */
    public function __construct($environment)
    {
        $this->environment = $environment;
    }

    /**
     * @param string $username
     * @param string $secret
     * @return string
     */
    public function getUri($username, $secret)
    {
        $issuer = ('prod' !== $this->environment ? 'sso-sso-' . $this->environment : 'sso-sso');
        return 'otpauth://totp/' . $username . '?secret=' . $secret . '&issuer=' . $issuer;
    }
}
