<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\MfaBundle\Tests\Api\Mfa\OtpAuth\Index;

use LifeStyle\Tools\MfaBundle\Api\Mfa\OtpAuth\Index as OtpAuth;
use PHPUnit\Framework\TestCase;

/**
 * Class IndexTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package LifeStyle\Tools\MfaBundle\Tests\Api\Mfa\OtpAuth\Index
 */
class IndexTest extends TestCase
{
    /**
     * @param string $environment
     * @param string $username
     * @param string $secret
     * @param string $expected
     * @dataProvider getTestValues()
     */
    public function testGetUri($environment, $username, $secret, $expected)
    {
        $otpAuth = new OtpAuth($environment);
        static::assertEquals($expected, $otpAuth->getUri($username, $secret));
    }

    /**
     * @return array
     */
    public function getTestValues()
    {
        return [
            [
                'my-test-env',
                'rabbit',
                'white-secret',
                'otpauth://totp/rabbit?secret=white-secret&issuer=sso-sso-my-test-env'
            ],
            ['prod', 'tiger', 'black-stone', 'otpauth://totp/tiger?secret=black-stone&issuer=sso-sso'],
            [
                'staging',
                'mouse',
                'cat-will-kill-me',
                'otpauth://totp/mouse?secret=cat-will-kill-me&issuer=sso-sso-staging'
            ],
        ];
    }
}
