<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ORMHelperBundle\Helper;

use Doctrine\ORM\Id\AbstractIdGenerator;

/**
 * Class GuidGenerator
 * @package LifeStyle\Tools\ORMHelperBundle\Helper
 */
class GuidGenerator extends AbstractIdGenerator
{
    /**
     * format like
     * 00006335-D78F-1236-C710-22FAAC0E7CFF
     * @return string
     */
    public function getGUID()
    {
        mt_srand((double)microtime() * 10000); //optional for php 4.2.0 and up.
        $charid = strtoupper(md5(uniqid(rand(), true)));
        $hyphen = chr(45); // "-"
        $uuid = substr($charid, 0, 8).$hyphen
            .substr($charid, 8, 4).$hyphen
            .substr($charid, 12, 4).$hyphen
            .substr($charid, 16, 4).$hyphen
            .substr($charid, 20, 12);

        return $uuid;
    }

    /**
     * @param \Doctrine\ORM\EntityManager $em
     * @param object $entity
     * @return string
     */
    public function generate(\Doctrine\ORM\EntityManager $em, $entity)
    {
        return $this->getGUID();
    }
}
