<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\ORMHelperBundle\Helper;

use \Doctrine\ORM\Id\AbstractIdGenerator;

/**
 * Class Id64Generator
 * @package LifeStyle\Tools\ORMHelperBundle\Helper
 */
class Id64Generator extends AbstractIdGenerator
{
    /**
     * @param \Doctrine\ORM\EntityManager $em
     * @param \Doctrine\ORM\Mapping\Entity $entity
     * @return string
     */
    public function generate(\Doctrine\ORM\EntityManager $em, $entity)
    {
        return hash('sha256', mt_rand() . '#' . microtime());
    }
}
