<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Entity\Usage;

use Doctrine\ORM\Mapping as ORM;

/**
 * WsseTokens
 *
 * @ORM\Table(name="rest_wsse_tokens")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 */
class WsseTokens
{
    /**
     * @var string
     *
     * @ORM\Column(name="guid", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="CUSTOM")
     * @ORM\CustomIdGenerator(class="\LifeStyle\Tools\ORMHelperBundle\Helper\GuidGenerator")
     */
    private $guid;

    /**
     * @var string
     *
     * @ORM\Column(name="userName", type="string", length=255)
     */
    private $userName;

    /**
     * @var string
     *
     * @ORM\Column(name="passwordDigest", type="string", length=255)
     */
    private $passwordDigest;

    /**
     * @var string
     *
     * @ORM\Column(name="nonce", type="string", length=255)
     */
    private $nonce;

    /**
     * @var string
     *
     * @ORM\Column(name="request_created", type="string", length=255)
     */
    private $requestCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="created", type="datetime")
     */
    private $created;


    /**
     * Get guid
     *
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * Set userName
     *
     * @param string $userName
     *
     * @return WsseTokens
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;

        return $this;
    }

    /**
     * Get userName
     *
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * Set passwordDigest
     *
     * @param string $passwordDigest
     *
     * @return WsseTokens
     */
    public function setPasswordDigest($passwordDigest)
    {
        $this->passwordDigest = $passwordDigest;

        return $this;
    }

    /**
     * Get passwordDigest
     *
     * @return string
     */
    public function getPasswordDigest()
    {
        return $this->passwordDigest;
    }

    /**
     * Set nonce
     *
     * @param string $nonce
     *
     * @return WsseTokens
     */
    public function setNonce($nonce)
    {
        $this->nonce = $nonce;

        return $this;
    }

    /**
     * Get nonce
     *
     * @return string
     */
    public function getNonce()
    {
        return $this->nonce;
    }

    /**
     * Set created
     *
     * @param \DateTime $created
     *
     * @return WsseTokens
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @return string
     */
    public function getRequestCreated()
    {
        return $this->requestCreated;
    }

    /**
     * @param string $requestCreated
     * @return WsseTokens
     */
    public function setRequestCreated($requestCreated)
    {
        $this->requestCreated = $requestCreated;

        return $this;
    }

    /**
     * Set created
     *
     * @ORM\PrePersist
     */
    public function setCreatedAt()
    {
        $this->created = new \DateTime();
    }
}
