<?php

/**
 * 
 * @class Index
 * @author buchhofer
 * 
 * 
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 * 
 */
namespace LifeStyle\Tools\RestErrorBundle\Api\Error;

use Symfony\Bridge\Monolog\Logger;

class Factory
{

    /**
     *
     * @var array 
     */
    protected $factorySetter;
    
    /**
     *
     * @var Logger 
     */
    protected $log;

    /**
     * 
     * @param LoggerInterface $log
     */
    public function __construct(Logger $log)
    {
        $this->log = $log;
    }
    /**
     * 
     * @return Errors\Index
     */
    public function errors()
    {
        if(!isset($this->factorySetter['errors'])){
            $this->factorySetter['errors'] = new Errors\Index($this->log);
        }
        return $this->factorySetter['errors'];
    }

    /**
     * 
     * @return Response\Index
     */
    public function response()
    {
        if(!isset($this->factorySetter['response'])){
            $this->factorySetter['response'] = new Response\Index();
        }
        return $this->factorySetter['response'];
    }

    /**
     * 
     * @return View\Index
     */
    public function view()
    {
        if(!isset($this->factorySetter['view'])){
            $this->factorySetter['view'] = new View\Index();
        }
        return $this->factorySetter['view'];
    }
    
     /**
     * 
     * @return Helper\Index
     */
    public function helper()
    {
        if (!isset($this->factorySetter['helper'])) {
            $this->factorySetter['helper'] = new Helper\Index();
        }
        return $this->factorySetter['helper'];
    }

}
