<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Tests\Api\Helper;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use LifeStyle\Tools\RestErrorBundle\Api;
use Symfony\Component\Security\Core\Exception\AuthenticationException;

/**
 * Class IndexTest
 * @package LifeStyle\Tools\RestErrorBundle\Tests\Api\Helper
 */
class IndexTest extends WebTestCase
{
    /**
     * @var Api\Manager
     */
    public $errorApiM;

    /**
     * @var Client
     */
    protected $client;

    /**
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->errorApiM = new Api\Manager($this->container);
    }

    public function testClassNameFromObjectNamespace()
    {
        $failed = null;
        try {
            $this->exceptionAuthenticationException();
        } catch (AuthenticationException $failed) {

        }
        // asserts
        $this->assertTrue($this->errorApiM->error()->helper()->getClassNameFromObject($failed) == 'AuthenticationException');
    }
    
    public function testClassNameFromString()
    {
        // asserts
        $this->assertTrue($this->errorApiM->error()->helper()->getClassNameFromObject('TestClass') == 'TestClass');
    }

    /**
     * @throws AuthenticationException
     */
    private function exceptionAuthenticationException()
    {
        throw new AuthenticationException();
    }
}
