<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Tests\Api;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use LifeStyle\Tools\RestErrorBundle\Api;
use Symfony\Component\Security\Core\Exception\AuthenticationException;

/**
 * Class ManagerTest
 * @package LifeStyle\Tools\RestErrorBundle\Tests\Api
 */
class ManagerTest extends WebTestCase
{
    /**
     * @var Api\Manager
     */
    public $errorApiM;

    /**
     * @var Client
     */
    protected $client;

    /**
     * @var ContainerInterface
     */
    protected $container;

    protected function setUp()
    {
        $this->client = static::createClient();
        $this->container = $this->client->getContainer();
        $this->errorApiM = new Api\Manager($this->container);
    }

    public function testSerializer()
    {
        // asserts
        $this->assertInstanceOf('\JMS\Serializer\Serializer', $this->errorApiM->serializer());
    }

    public function testLogger()
    {
        // asserts
        $this->assertInstanceOf('\Symfony\Bridge\Monolog\Logger', $this->errorApiM->logger());
    }

    public function testViewErrorsView()
    {
        // asserts
        $this->assertInstanceOf('\FOS\RestBundle\View\View', $this->errorApiM->error()->view()->getErrorsView(null));
    }
    
    public function testResponseResponse()
    {
        // asserts
        $this->assertInstanceOf('\Symfony\Component\HttpFoundation\Response', $this->errorApiM->error()->response()->response());
    }
    
    public function testResponseJson()
    {
        // asserts
        $this->assertInstanceOf('\Symfony\Component\HttpFoundation\JsonResponse', $this->errorApiM->error()->response()->jsonResponse());
    }
}
