<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Migrations\AbortMigrationException;
use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;
use Ramsey\Uuid\Uuid;

require_once dirname(__DIR__) . '/InstallTrait.php';

/**
 * Class Version20190916062001
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package DoctrineMigrations
 */
class Version20190916062001 extends AbstractMigration
{
    use InstallTrait;

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE webservice_access_log (id CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', username VARCHAR(255) NOT NULL, token VARCHAR(255) DEFAULT NULL, services LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE saml_user_history (id CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', local_user_id CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', user_identifier VARCHAR(255) NOT NULL, last_login_at DATETIME NOT NULL, INDEX IDX_5B681BDD3ABBD618 (local_user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE saml_user (id CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', user_guid VARCHAR(255) NOT NULL, user_email VARCHAR(255) DEFAULT NULL, user_name VARCHAR(255) DEFAULT NULL, first_name VARCHAR(255) DEFAULT NULL, last_name VARCHAR(255) DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE saml_user_action_log (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid_binary)\', local_user_id CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', controller VARCHAR(127) NOT NULL, action VARCHAR(127) NOT NULL, type VARCHAR(32) NOT NULL, created_at DATETIME NOT NULL, ip_address VARCHAR(32) DEFAULT NULL, stats LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_A58F332F3ABBD618 (local_user_id), INDEX idx_created (created_at, local_user_id, controller, action, type, ip_address), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE saml_user_action_log_data (id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid_binary)\', request_data LONGTEXT DEFAULT NULL, response_data LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_68C078F3BF396750 (id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE rest_service_token (id INT AUTO_INCREMENT NOT NULL, token VARCHAR(255) NOT NULL, service VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE backend_user (id INT AUTO_INCREMENT NOT NULL, username VARCHAR(180) NOT NULL, username_canonical VARCHAR(180) NOT NULL, email VARCHAR(180) NOT NULL, email_canonical VARCHAR(180) NOT NULL, enabled TINYINT(1) NOT NULL, salt VARCHAR(255) DEFAULT NULL, password VARCHAR(255) NOT NULL, last_login DATETIME DEFAULT NULL, confirmation_token VARCHAR(180) DEFAULT NULL, password_requested_at DATETIME DEFAULT NULL, roles LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', firstname VARCHAR(127) DEFAULT NULL, lastname VARCHAR(127) DEFAULT NULL, organisation VARCHAR(127) DEFAULT NULL, UNIQUE INDEX UNIQ_C73586E92FC23A8 (username_canonical), UNIQUE INDEX UNIQ_C73586EA0D96FBF (email_canonical), UNIQUE INDEX UNIQ_C73586EC05FB297 (confirmation_token), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE saml_user_history ADD CONSTRAINT FK_5B681BDD3ABBD618 FOREIGN KEY (local_user_id) REFERENCES saml_user (id)');
        $this->addSql('ALTER TABLE saml_user_action_log ADD CONSTRAINT FK_A58F332F3ABBD618 FOREIGN KEY (local_user_id) REFERENCES saml_user (id)');
        $this->addSql('ALTER TABLE saml_user_action_log_data ADD CONSTRAINT FK_68C078F3BF396750 FOREIGN KEY (id) REFERENCES saml_user_action_log (id) ON DELETE CASCADE');
    }

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE saml_user_history DROP FOREIGN KEY FK_5B681BDD3ABBD618');
        $this->addSql('ALTER TABLE saml_user_action_log DROP FOREIGN KEY FK_A58F332F3ABBD618');
        $this->addSql('ALTER TABLE saml_user_action_log_data DROP FOREIGN KEY FK_68C078F3BF396750');
        $this->addSql('DROP TABLE webservice_access_log');
        $this->addSql('DROP TABLE saml_user_history');
        $this->addSql('DROP TABLE saml_user');
        $this->addSql('DROP TABLE saml_user_action_log');
        $this->addSql('DROP TABLE saml_user_action_log_data');
        $this->addSql('DROP TABLE rest_service_token');
        $this->addSql('DROP TABLE backend_user');
    }

    /**
     * @param Schema $schema
     * @throws DBALException
     * @throws AbortMigrationException
     */
    public function postUp(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $token = hash('md5', Uuid::uuid4()->toString());
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (1, \'' . $token . '\', \'api_rest_idp_post_login\')');
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (2, \'' . $token . '\', \'api_rest_idp_post_login_success\')');
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (3, \'' . $token . '\', \'api_rest_idp_post_login_failed\')');
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (4, \'' . $token . '\', \'api_rest_idp_post_mfa_add_user\')');
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (5, \'' . $token . '\', \'api_rest_idp_post_mfa_validate\')');
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (6, \'' . $token . '\', \'api_rest_idp_post_mfa_validate\')');
        $this->connection->executeQuery('INSERT INTO `rest_service_token` VALUES (7, \'' . $token . '\', \'api_rest_uaa_post_user_application_attributes\')');
        $this->addInstallDocsAttribute(['backend' => ['idp' => ['rest_token' => $token]]]);

        $this->connection->executeQuery('INSERT INTO `backend_user` (`id`, `username`, `username_canonical`, `email`, `email_canonical`, `enabled`, `salt`, `password`, `last_login`, `confirmation_token`, `password_requested_at`, `roles`, `firstname`, `lastname`, `organisation`) VALUES (1, \'admin\', \'admin\', \'info@life-style.de\', \'info@life-style.de\', 1, \'RDAF.dLI/HnEwXFWDP8rXWvpmyXFm7Ldi3HRp1PKcwo\', \'PhW98mUSOkzz/MvY6kr0phleyYzNeVfDQgIwyWoq42Ii68qO0Df7NY1P1lRKrZMwRod5D54XMEkSCw6yyVlP9w==\', NULL, NULL, NULL, \'a:1:{i:0;s:16:\"ROLE_SUPER_ADMIN\";}\', \'admin\', \'admin\', \'Life-Style\');');
        $this->addInstallDocsAttribute(['backend' => ['user' => ['username' => 'admin', 'password' => 'admin']]]);
    }
}
