<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\Migrations\AbortMigrationException;
use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

require_once dirname(__DIR__) . '/InstallTrait.php';

/**
 * Class Version20190916072316
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package DoctrineMigrations
 */
class Version20190916072316 extends AbstractMigration
{
    use InstallTrait;

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function up(Schema $schema)
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE backend_session (session_id VARCHAR(255) NOT NULL, session_value BLOB NOT NULL, session_time INT NOT NULL, session_lifetime BIGINT NOT NULL, PRIMARY KEY(session_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE system_log (id VARCHAR(64) NOT NULL, level INT DEFAULT NULL, channel VARCHAR(32) DEFAULT NULL, extras VARCHAR(32) DEFAULT NULL, username VARCHAR(32) DEFAULT NULL, modified DATETIME NOT NULL, created DATETIME NOT NULL, createdTime BIGINT UNSIGNED NOT NULL, INDEX idx_level (level, createdTime, created, modified, extras, channel, username), INDEX idx_channel (channel, createdTime, created, modified, extras, level, username), INDEX idx_extras (extras, createdTime, created, modified, channel, level, username), INDEX idx_createdTime (createdTime, created, modified, extras, channel, level, username), INDEX idx_username (username, createdTime, created, modified, extras, channel, level), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE system_log_data (id VARCHAR(64) NOT NULL, log LONGTEXT DEFAULT NULL, serverData LONGTEXT DEFAULT NULL, UNIQUE INDEX UNIQ_D577AC94BF396750 (id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE rest_wsse_tokens (guid VARCHAR(36) NOT NULL, userName VARCHAR(255) NOT NULL, passwordDigest VARCHAR(255) NOT NULL, nonce VARCHAR(255) NOT NULL, request_created VARCHAR(255) NOT NULL, created DATETIME NOT NULL, PRIMARY KEY(guid)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE system_log_data ADD CONSTRAINT FK_D577AC94BF396750 FOREIGN KEY (id) REFERENCES system_log (id) ON DELETE CASCADE');
    }

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function down(Schema $schema)
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE system_log_data DROP FOREIGN KEY FK_D577AC94BF396750');
        $this->addSql('DROP TABLE backend_session');
        $this->addSql('DROP TABLE system_log');
        $this->addSql('DROP TABLE system_log_data');
        $this->addSql('DROP TABLE rest_wsse_tokens');
    }
}
