<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace DoctrineMigrations;

use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Migrations\AbortMigrationException;
use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Class Version20190916083560
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package DoctrineMigrations
 */
class Version20190916083560 extends AbstractMigration
{
    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function up(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
    }

    /**
     * @param Schema $schema
     * @throws AbortMigrationException
     */
    public function down(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');
    }

    /**
     * Insert new services for user-group api-services
     * @param Schema $schema
     * @throws DBALException
     */
    public function postUp(Schema $schema)
    {
        if (!$this->connection->executeQuery('SELECT COUNT(*) FROM `wssp_services` WHERE `ServiceController` = "UserGroup" AND `ServiceAction` = "Add"')->fetchColumn()) {
            $this->connection->executeQuery('INSERT INTO `wssp_services`(`ServiceType`, `ServiceController`, `ServiceAction`, `ServiceMapped2Group`) VALUES (\'intern\', \'UserGroup\', \'Add\', \'no\')');
        }
        if (!$this->connection->executeQuery('SELECT COUNT(*) FROM `wssp_services` WHERE `ServiceController` = "UserGroup" AND `ServiceAction` = "Delete"')->fetchColumn()) {
            $this->connection->executeQuery('INSERT INTO `wssp_services`(`ServiceType`, `ServiceController`, `ServiceAction`, `ServiceMapped2Group`) VALUES (\'intern\', \'UserGroup\', \'Delete\', \'no\')');
        }
        if (!$this->connection->executeQuery('SELECT COUNT(*) FROM `wssp_services` WHERE `ServiceController` = "UserGroup" AND `ServiceAction` = "Update"')->fetchColumn()) {
            $this->connection->executeQuery('INSERT INTO `wssp_services`(`ServiceType`, `ServiceController`, `ServiceAction`, `ServiceMapped2Group`) VALUES (\'intern\', \'UserGroup\', \'Update\', \'no\')');
        }
        if (!$this->connection->executeQuery('SELECT COUNT(*) FROM `wssp_services` WHERE `ServiceController` = "UserGroup" AND `ServiceAction` = "Search"')->fetchColumn()) {
            $this->connection->executeQuery('INSERT INTO `wssp_services`(`ServiceType`, `ServiceController`, `ServiceAction`, `ServiceMapped2Group`) VALUES (\'intern\', \'UserGroup\', \'Search\', \'no\')');
        }
    }
}
