<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\AccessBundle\Authorization;

/**
 * Interface TemporaryTokenAuthorizationInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\AccessBundle\Authorization
 */
interface TemporaryTokenAuthorizationInterface
{
    /**
     * Returns a list of user-ids for which current consumer has grant access
     *
     * @return array
     */
    public function getAuthorizedUserIds(): array;

    /**
     * Adds a user-id to the list of users for which the current consumer
     * should have grant access in further requests
     *
     * @param string $userId
     */
    public function addAuthorizedUserId(string $userId): void;
}
