<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class AdminController
 * @package Sso\BackendBundle\Controller
 */
class AdminController extends Controller
{

    /**
     * @Route("/", name="_backend_admin_index")
     * @Template()
     * @return Response
     */
    public function indexAction()
    {
        return [];
    }

    /**
     * @Route("/", name="_backend_admin_welcome")
     * @Template()
     * @return Response
     */
    public function welcomeAction()
    {
        return [];
    }

    /**
     * @Route("/", name="_backend_admin_changelog")
     * @Template()
     * @return Response
     */
    public function changelogAction()
    {
        return array();
    }

    /**
     * @Route("/system-check", name="_backend_admin_systemcheck")
     * @return Response
     */
    public function systemCheckAction()
    {
        $openSslCypherNames = $this->get('ciphering_api_manager')->ciphering()->configuration()->getOpenSslCipherNames();
        $openSslCypherNamesSupported = array_map(function ($openSslCypherName) {
            return in_array(strtolower($openSslCypherName), openssl_get_cipher_methods());
        }, $openSslCypherNames);
        return $this->render('@SsoBackend/Admin/system_check.html.twig',[
            'useOpenSsl' => function_exists('openssl_decrypt'),
            'openSslCypherNames' => $openSslCypherNames,
            'openSslCypherNamesSupported' => $openSslCypherNamesSupported,
        ]);
    }
}
