<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Lexik\Bundle\FormFilterBundle\Filter\Form\Type as Filters;

/**
 * Class PasswordPoliciesFilterType
 * @package Sso\BackendBundle\Form
 */
class PasswordPoliciesFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add(
                'policyId',
                Filters\TextFilterType::class
            )
            ->add(
                'regEx',
                Filters\TextFilterType::class
            )
            ->add(
                'validityDuration',
                Filters\NumberFilterType::class
            )
            ->add(
                'historySize',
                Filters\NumberFilterType::class
            )
            ->add(
                'editDistance',
                Filters\NumberFilterType::class
            )
            ->add(
                'changeDelay',
                Filters\NumberFilterType::class
            )
            ->add(
                'policyDescription',
                Filters\TextFilterType::class
            )
            ->add(
                'isDefault',
                Filters\CheckboxFilterType::class
            );
    }

    /**
     * @return string
     */
    public function getBlockPrefix()
    {
        return 'policies_filter';
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'csrf_protection' => false,
                'validation_groups' => array('filtering') // avoid NotBlank() constraint-related message
            ]
        );
    }
}
