<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Sso\BackendBundle\Model\Form\PasswordPolicyValidations;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Class PasswordPolicyValidationsType
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\BackendBundle\Form
 */
class PasswordPolicyValidationsType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add(
            'regEx',
            TextType::class,
            [
                'label' => 'Regular Expression'
            ]
        );
        $builder->add(
            'errorMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'attr' => [
                    'data-btn-text-add' => 'Add Error Translation',
                    'data-btn-text-delete' => 'Delete Error Translation',
                ],
            ]
        );
        $builder->add(
            'hintMessages',
            CollectionType::class,
            [
                'entry_type' => PasswordPoliciesTranslationsType::class,
                'entry_options' => [
                    'label' => false,
                ],
                'allow_add' => true,
                'allow_delete' => true,
                'attr' => [
                    'data-btn-text-add' => 'Add Hint Translation',
                    'data-btn-text-delete' => 'Delete Hint Translation',
                ],
            ]
        );
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => PasswordPolicyValidations::class,
        ]);
    }
}
