<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Sso\BackendBundle\Model\Form\UserCsvRowApplicationRole;
use Sso\WebserviceBundle\Database\Webservice\Application as ApplicationDatabase;
use Sso\WebserviceBundle\Entity\Webservice\Type\Application;
use Sso\WebserviceBundle\Entity\Webservice\Type\Role;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class WsUserCsvRowApplicationRoleType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Form
 */
class WsUserCsvRowApplicationRoleType extends AbstractType
{
    /**
     * @var ApplicationDatabase
     */
    private $applicationDatabase;

    /**
     * WsUserCsvRowApplicationType constructor.
     * @param ApplicationDatabase $applicationDatabase
     */
    public function __construct(ApplicationDatabase $applicationDatabase)
    {
        $this->applicationDatabase = $applicationDatabase;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('application', EntityType::class, [
            'class' => Application::class,
            'placeholder' => '',
            'choices' => $this->getApplications(),
            'choice_label' => 'name',
            'choice_value' => 'id',
            'attr' => ['class' => 'dynamic-form'],
        ]);

        $formModifier = function (FormInterface $form, Application $application = null) {
            $form->add('role', EntityType::class, [
                'class' => Role::class,
                'placeholder' => '',
                'choices' => null !== $application ? $application->getRoles() : [],
                'choice_label' => 'name',
                'choice_value' => 'id',
            ]);
        };

        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier) {
                $formData = $event->getData();
                $formModifier($event->getForm(), null !== $formData ? $formData->getApplication() : null);
            }
        );

        $builder->get('application')->addEventListener(
            FormEvents::POST_SUBMIT,
            function (FormEvent $event) use ($formModifier) {
                $formModifier($event->getForm()->getParent(), $event->getForm()->getData());
            }
        );
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => UserCsvRowApplicationRole::class,
        ]);
    }

    /**
     * @return Application[]
     */
    private function getApplications()
    {
        return array_filter($this->applicationDatabase->getAllApplications(), function(Application $application) {
            return $application->hasRoles();
        });
    }
}
