<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Sso\BackendBundle\Model\Form\UserCsvRow;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Class WsUserCsvRowType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\BackendBundle\Form
 */
class WsUserCsvRowType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('targetEntity', Type\ChoiceType::class, [
            'choices' => [
                'Ignore Column' => 'ignore',
                'User' => 'user',
                'Application Attribute' => 'attribute',
                'Application Role' => 'role',
            ],
            'choices_as_values' => true,
            'attr' => ['class' => 'dynamic-form'],
        ]);

        $builder->add('rowId', Type\HiddenType::class, [
            'attr' => [
                'class' => 'dynamic-position-form',
            ],
        ]);

        $formModifier = function (FormInterface $form, string $targetEntity = null) {
            if ('attribute' === $targetEntity) {
                $form->add(
                    'applicationAttribute',
                    WsUserCsvRowApplicationAttributeType::class,
                    ['label' => false]
                );
                $form->remove('user');
                $form->remove('applicationRole');
            } elseif ('role' === $targetEntity) {
                $form->add(
                    'applicationRole',
                    WsUserCsvRowApplicationRoleType::class,
                    ['label' => false]
                );
                $form->remove('user');
                $form->remove('applicationAttribute');
            } elseif ('user' === $targetEntity) {
                $form->add(
                    'user',
                    WsUserCsvRowUserType::class,
                    ['label' => false]
                );
                $form->remove('applicationAttribute');
                $form->remove('applicationRole');
            } elseif ('ignore' === $targetEntity) {
                $form->remove('user');
                $form->remove('applicationAttribute');
                $form->remove('applicationRole');
            }
        };

        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier) {
                $formData = $event->getData();
                $formModifier($event->getForm(), $formData !== null ? $formData->getTargetEntity() : null);
            }
        );

        $builder->get('targetEntity')->addEventListener(
            FormEvents::POST_SUBMIT,
            function (FormEvent $event) use ($formModifier) {
                $formModifier($event->getForm()->getParent(), $event->getForm()->getData());
            }
        );
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => UserCsvRow::class,
        ]);
    }
}
