<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Lexik\Bundle\FormFilterBundle\Filter\Form\Type as FilterType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormError;

/**
 * Class WsUserFilterType
 * @package Sso\BackendBundle\Form
 */
class WsUserFilterType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('Id', FilterType\TextFilterType::class)
            ->add('Guid', FilterType\TextFilterType::class)
            ->add('LowerEmail', FilterType\TextFilterType::class, array('label' => 'Email'))
            ->add('LowerUsername', FilterType\TextFilterType::class, array('label' => 'Username'))
            ->add('Firstname', FilterType\TextFilterType::class)
            ->add('Lastname', FilterType\TextFilterType::class)
            ->add('AuthId', FilterType\TextFilterType::class);

        $listener = function (FormEvent $event) {

            // Is data empty?
            if ($this->isEmpty($event->getData())) {
                $event->getForm()->addError(new FormError('Filter empty'));
            }
        };
        $builder->addEventListener(FormEvents::POST_SUBMIT, $listener);
    }

    /**
     * @param mixed $data
     * @return boolean
     */
    private function isEmpty($data)
    {
        if (is_array($data)) {
            foreach ($data as $value) {
                if (!$this->isEmpty($value)) {
                    return false;
                }
            }

            return true;
        }

        return empty($data);
    }

    public function getName()
    {
        return 'sso_backendbundle_webserviceuserfiltertype';
    }

}
