<?php
/**
 *
 * @author sb
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Form;

use Doctrine\ORM\EntityRepository;
use Sso\WebserviceBundle\Entity\Webservice\Type\UserGroup;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

/**
 * Class WsUserType
 * @package Sso\BackendBundle\Form
 */
class WsUserType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $passwordPolicyChoiceList = $options['password_policy_choices'];
        $passwordEncryptTypeChoiceList = $options['password_encrypt_type_choices'];

        $builder->add('Email', null, ['required' => false])
            ->add('Username')
            ->add('Password', 'password', array('required' => false))
            ->add('Firstname')
            ->add('Lastname')
            ->add('Active', 'choice', array(
                'choices' => array(
                    0 => 'Inactive',
                    1 => 'Active',
                ),
            ))
            ->add('Deleted', 'choice', array(
                'choices' => array(
                    0 => 'No',
                    1 => 'Yes',
                ),
            ))
            ->add('AuthId')
            ->add('LdapSearchAttributes')
            ->add('LdapSearchValue')
            ->add('MfaEnabled', 'choice', array(
                'label' => 'MFA Enabled. If you turn off MFA, the previous MFA secret will be lost.',
                'choices' => array(
                    0 => 'No',
                    1 => 'Yes',
                ),
            ))
            ->add('MfaRecreate', 'choice', array(
                'label' => 'Create a new MFA secret. The qr-code containing this secret will be shown at the next user login. This may be used, if the user has lost his MFA secret.',
                'choices' => array(
                    0 => 'No',
                    1 => 'Yes',
                ),
            ))
            ->add('ActivateTokenRecreate', 'choice', array(
                'label' => 'Create a activation token. Use this option if the users activation token after registration has expired.',
                'choices' => array(
                    0 => 'No',
                    1 => 'Yes',
                ),
            ))
            ->add('LoginFails')
            ->add('passwordPolicy', 'choice', array(
                'required' => false,
                'choices' => $passwordPolicyChoiceList
            ))
            ->add('lastPasswordChange', null, ['required' => false])
            ->add('passwordExpired', 'choice', array(
                'required' => false,
                'choices' => [
                    0 => 'no',
                    1 => 'yes'
                ]
            ))
            ->add('passwordEncryptType', 'choice', array(
                'required' => true,
                'choices' => array_combine($passwordEncryptTypeChoiceList, $passwordEncryptTypeChoiceList)
            ))
            ->add('userGroups', EntityType::class, [
                'class'     => UserGroup::class,
                'required' => false,
                'choice_label' => 'name',
                'query_builder' => function (EntityRepository $repo) {
                    return $repo->createQueryBuilder('g')->orderBy('g.name');
                },
                'label'     => 'User Groups',
                'multiple'  => true,
            ])
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(
            [
                'data_class' => 'Sso\WebserviceBundle\Entity\Webservice\Type\User',
                'password_policy_choices' => null,
                'password_encrypt_type_choices' => null,
            ]
        );
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendbundle_webserviceuser';
    }
}
