<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Validator\Constraints as Assert;
use Sso\BackendBundle\Validator\Constraints as BackendAssert;

/**
 * Class PasswordPolicy
 * @package Sso\BackendBundle\Model\Form
 */
class PasswordPolicy
{
    /**
     * @var string
     */
    private $policyId;

    /**
     * @Assert\NotBlank
     * @var string
     */
    private $title;

    /**
     * @BackendAssert\IsValidRegex
     * @var string
     */
    private $regEx;

    /**
     * @Assert\Valid()
     * @var array
     */
    private $regexErrorMessages = [];

    /**
     * @Assert\GreaterThanOrEqual(0)
     * @var integer
     */
    private $validityDuration = 0;

    /**
     * @Assert\Valid()
     * @var array
     */
    private $validityDurationErrorMessages = [];

    /**
     * @Assert\GreaterThanOrEqual(0)
     * @var integer
     */
    private $historySize = 0;

    /**
     * @Assert\Valid()
     * @var array
     */
    private $historySizeErrorMessages = [];

    /**
     * @Assert\GreaterThanOrEqual(0)
     * @var integer
     */
    private $editDistance = 0;

    /**
     * @Assert\Valid()
     * @var array
     */
    private $editDistanceErrorMessages = [];

    /**
     * @Assert\GreaterThanOrEqual(0)
     * @var integer
     */
    private $changeDelay = 0;

    /**
     * @Assert\Valid()
     * @var array
     */
    private $changeDelayErrorMessages = [];

    /**
     * @var string
     */
    private $policyDescription = 'Description';

    /**
     * @var bool
     */
    private $isDefault;

    /**
     * @Assert\Valid()
     * @var array
     */
    private $errorMessages = [];

    /**
     * @Assert\Valid()
     * @var PasswordPolicyValidations[]
     */
    private $passwordPolicyValidations;

    /**
     * @return string
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }

    /**
     * @param string $policyId
     * @return PasswordPolicy
     */
    public function setPolicyId($policyId)
    {
        $this->policyId = $policyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return PasswordPolicy
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return PasswordPolicy
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return int
     */
    public function getValidityDuration()
    {
        return $this->validityDuration;
    }

    /**
     * @param int $validityDuration
     * @return PasswordPolicy
     */
    public function setValidityDuration($validityDuration)
    {
        $this->validityDuration = $validityDuration;
        return $this;
    }

    /**
     * @return int
     */
    public function getHistorySize()
    {
        return $this->historySize;
    }

    /**
     * @param int $historySize
     * @return PasswordPolicy
     */
    public function setHistorySize($historySize)
    {
        $this->historySize = $historySize;
        return $this;
    }

    /**
     * @return int
     */
    public function getEditDistance()
    {
        return $this->editDistance;
    }

    /**
     * @param int $editDistance
     * @return PasswordPolicy
     */
    public function setEditDistance($editDistance)
    {
        $this->editDistance = $editDistance;
        return $this;
    }

    /**
     * @return int
     */
    public function getChangeDelay()
    {
        return $this->changeDelay;
    }

    /**
     * @param int $changeDelay
     * @return PasswordPolicy
     */
    public function setChangeDelay($changeDelay)
    {
        $this->changeDelay = $changeDelay;
        return $this;
    }

    /**
     * @return string
     */
    public function getPolicyDescription()
    {
        return $this->policyDescription;
    }

    /**
     * @param string $policyDescription
     * @return PasswordPolicy
     */
    public function setPolicyDescription($policyDescription)
    {
        $this->policyDescription = $policyDescription;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isDefault()
    {
        return $this->isDefault;
    }

    /**
     * @param string $isDefault
     * @return PasswordPolicy
     */
    public function setDefault($isDefault)
    {
        $this->isDefault = $isDefault;
        return $this;
    }

    /**
     * @return array
     */
    public function getRegexErrorMessages()
    {
        return $this->regexErrorMessages;
    }

    /**
     * @param array $regexErrorMessages
     * @return PasswordPolicy
     */
    public function setRegexErrorMessages($regexErrorMessages)
    {
        $this->regexErrorMessages = $regexErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getValidityDurationErrorMessages()
    {
        return $this->validityDurationErrorMessages;
    }

    /**
     * @param array $validityDurationErrorMessages
     * @return PasswordPolicy
     */
    public function setValidityDurationErrorMessages($validityDurationErrorMessages)
    {
        $this->validityDurationErrorMessages = $validityDurationErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getHistorySizeErrorMessages()
    {
        return $this->historySizeErrorMessages;
    }

    /**
     * @param array $historySizeErrorMessages
     * @return PasswordPolicy
     */
    public function setHistorySizeErrorMessages($historySizeErrorMessages)
    {
        $this->historySizeErrorMessages = $historySizeErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getEditDistanceErrorMessages()
    {
        return $this->editDistanceErrorMessages;
    }

    /**
     * @param array $editDistanceErrorMessages
     * @return PasswordPolicy
     */
    public function setEditDistanceErrorMessages($editDistanceErrorMessages)
    {
        $this->editDistanceErrorMessages = $editDistanceErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getChangeDelayErrorMessages()
    {
        return $this->changeDelayErrorMessages;
    }

    /**
     * @param array $changeDelayErrorMessages
     * @return PasswordPolicy
     */
    public function setChangeDelayErrorMessages($changeDelayErrorMessages)
    {
        $this->changeDelayErrorMessages = $changeDelayErrorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param array $errorMessages
     * @return PasswordPolicy
     */
    public function setErrorMessages($errorMessages)
    {
        $this->errorMessages = $errorMessages;
        return $this;
    }

    /**
     * @return PasswordPolicyValidations[]
     */
    public function getPasswordPolicyValidations()
    {
        return $this->passwordPolicyValidations;
    }

    /**
     * @param PasswordPolicyValidations $passwordPolicyValidation
     */
    public function addPasswordPolicyValidation(PasswordPolicyValidations $passwordPolicyValidation)
    {
        $this->passwordPolicyValidations[] = $passwordPolicyValidation;
    }

    /**
     * @param PasswordPolicyValidations[] $passwordPolicyValidations
     * @return PasswordPolicy
     */
    public function setPasswordPolicyValidations($passwordPolicyValidations)
    {
        $this->passwordPolicyValidations = $passwordPolicyValidations;
        return $this;
    }
}
