<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class PasswordPolicyTranslations
 * @package Sso\BackendBundle\Model\Form
 */
class PasswordPolicyTranslations
{
    /**
     * @Assert\NotBlank
     * @var string
     */
    private $language;

    /**
     * @Assert\NotBlank
     * @var string
     */
    private $message;

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return PasswordPolicyTranslations
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return PasswordPolicyTranslations
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }
}
