<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendBundle\Model\Form;

use Symfony\Component\Validator\Constraints as Assert;
use Sso\BackendBundle\Validator\Constraints as BackendAssert;

/**
 * Class PasswordPolicyValidations
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\BackendBundle\Model\Form
 */
class PasswordPolicyValidations
{
    /**
     * @Assert\NotBlank
     * @BackendAssert\IsValidRegex
     * @var string
     */
    private $regEx;

    /**
     * @Assert\NotNull()
     * @Assert\Valid()
     * @var PasswordPolicyTranslations[]
     */
    private $errorMessages = [];

    /**
     * @Assert\NotNull()
     * @Assert\Valid()
     * @var PasswordPolicyTranslations[]
     */
    private $hintMessages = [];

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return PasswordPolicyValidations
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @param PasswordPolicyTranslations $errorMessage
     */
    public function addErrorMessage(PasswordPolicyTranslations $errorMessage)
    {
        $this->errorMessages[] = $errorMessage;
    }

    /**
     * @return PasswordPolicyTranslations[]
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param PasswordPolicyTranslations[] $errorMessages
     */
    public function setErrorMessages(array $errorMessages)
    {
        $this->errorMessages = [];
        foreach ($errorMessages as $errorMessage) {
            $this->addErrorMessage($errorMessage);
        }
    }

    /**
     * @param PasswordPolicyTranslations $hintMessage
     */
    public function addHintMessage(PasswordPolicyTranslations $hintMessage)
    {
        $this->hintMessages[] = $hintMessage;
    }

    /**
     * @return PasswordPolicyTranslations[]
     */
    public function getHintMessages()
    {
        return $this->hintMessages;
    }

    /**
     * @param PasswordPolicyTranslations[] $hintMessages
     */
    public function setHintMessages(array $hintMessages)
    {
        $this->hintMessages = [];
        foreach ($hintMessages as $hintMessage) {
            $this->addHintMessage($hintMessage);
        }
    }
}
