<?php

namespace Sso\BackendBundle\Tests\Controller;

use Sso\BackendBundle\Tests\FunctionalTestCase;

class PasswordPolicyControllerTest extends FunctionalTestCase
{
    public function testList()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/admin/passwordpolicies/list');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Add new policy")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Policy ID")')->count() > 0);
    }

    public function testAdd()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/admin/passwordpolicies/add');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Add new")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Save Policy")')->count() > 0);
    }

    public function testEdit()
    {
        $client = $this->makeClient(true);

        $client->request('GET', '/admin/passwordpolicies/0/edit');
        $this->assertTrue($client->getResponse()->getStatusCode() === 302);
    }

    public function testShow()
    {
        $client = $this->makeClient(true);

        //id zero not exists we expect a redirect response to list view
        $client->request('GET', '/admin/passwordpolicies/0/show');
        $this->assertTrue($client->getResponse()->getStatusCode() === 302);

    }

    public function testDelete()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/admin/passwordpolicies/0/delete');
        $this->assertTrue($client->getResponse()->getStatusCode() === 302);
    }
}
