<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\BackendSecurityBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

/**
 * Class User
 * @package Sso\BackendSecurityBundle\Form
 */
class User extends AbstractType
{

    /**
     * Admin user role hierarchy
     * @var array
     */
    private $roleHierarchy;

    /**
     * @param array $roleHierarchy
     */
    public function __construct(array $roleHierarchy)
    {
        $this->roleHierarchy = $roleHierarchy;
    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('Username')
            ->add('Email')
            ->add('Firstname')
            ->add('Lastname')
            ->add('Organisation')
            ->add('PlainPassword', 'password', array('label' => 'Password', 'required' => false))
            ->add('Enabled', 'choice', array(
                'choices' => array(
                    0 => 'No',
                    1 => 'Yes',
                ),
            ))
            ->add('Roles', 'choice', array(
                    'choices' => $this->getExistingRoles(),
                    'multiple' => true,
                    'expanded' => true,
                    'label' => 'Roles (ROLE_USER is added automatically)',
                )
            );
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array('data_class' => 'Sso\BackendSecurityBundle\Entity\User'));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'sso_backendsecuritybundle_user';
    }

    /**
     * @return array
     */
    protected function getExistingRoles()
    {
        $roles = array_keys($this->roleHierarchy);

        return array_combine($roles, $roles);
    }
}
