<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Nelmio\ApiDocBundle\Tests\Fixtures\Form\CollectionType;
use Sso\DemoBundle\Form\ApplicationAttribute\Add\AttributeOptionType;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class ApplicationAttributeController
 * @package Sso\DemoBundle\Controller
 */
class ApplicationAttributeController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_applicationattribute_show")
     * @Template()
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('ApplicationName', 'text')
            ->add('Name', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'ApplicationAttribute', 'Show');
    }

    /**
     * @Route("/", name="_sso_demo_applicationattribute_add")
     * @Template()
     */
    public function addAction(Request $request)
    {
        $defaultValues = [ 'AttributeOptions' => [ ['label' => '', 'value' => ''] ] ];
        $form = $this->createFormBuilder(array_merge($this->getFormDefaults(), $defaultValues))
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('ApplicationName', 'text')
            ->add('Name', 'text')
            ->add('Type', 'text')
            ->add('DisplayType', 'text', ['label' => 'Display Type'])
            ->add('AttributeOptions', 'collection', [
                'entry_type' => AttributeOptionType::class,
                'entry_options' => ['label' => false],
                'allow_add' => true,
                'allow_delete' => true,
                'delete_empty' => true,
                'attr' => [
                    'data-btn-text-add' => 'Add Option',
                    'data-btn-text-delete' => 'Remove Option',
                ],
            ])
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'ApplicationAttribute', 'Add');
    }

    /**
     * @Route("/", name="_sso_demo_applicationattribute_delete")
     * @Template()
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('Name', 'text')
            ->add('ApplicationName', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'ApplicationAttribute', 'Delete');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationAttributeShow($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <ApplicationAttribute>
                            <Show>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                    </ApplicationType>
                                    <AttributeType>
                                        <Name>" . $params['Name'] . "</Name>
                                    </AttributeType>
                                </Key>
                            </Show>
                        </ApplicationAttribute>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationAttributeAdd($params)
    {
        $displayType = '';
        $attributeOptions = [];

        if ($params['apiVersion'] > 1) {
            $displayType = 0 < strlen($params['DisplayType']) ? ('<DisplayType>' . $params['DisplayType'] . '</DisplayType>') : '';

            foreach ($params['AttributeOptions'] ?? [] as $attributeOption) {
                if (0 < strlen($attributeOption['label']) || 0 < strlen($attributeOption['value'])) {
                    $attributeOptions[] = '<AttributeOption>' .
                        '<Label>' . $attributeOption['label'] . '</Label>' .
                        '<Value>' . $attributeOption['value'] . '</Value>' .
                        '</AttributeOption>';
                }
            }
        }

        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <ApplicationAttribute>
                            <Add>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                    </ApplicationType>
                                </Key>
                                <Value>
                                    <AttributeType>
                                        <Name>" . $params['Name'] . "</Name>
                                        <Type>" . $params['Type'] . "</Type>
                                        " . $displayType . "
                                        " . implode('', $attributeOptions) . "
                                    </AttributeType>
                                </Value>
                            </Add>
                        </ApplicationAttribute>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationAttributeDelete($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <ApplicationAttribute>
                            <Delete>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                    </ApplicationType>
                                    <AttributeType>
                                        <Name>" . $params['Name'] . "</Name>
                                    </AttributeType>
                                </Key>
                            </Delete>
                        </ApplicationAttribute>
                    </SsoRequest>";
    }
}
