<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class ApplicationController
 * @package Sso\DemoBundle\Controller
 */
class ApplicationController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_application_all")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function allAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [2 => 'Version 2', 3 => 'Version 3']])
            ->add('fullResponse', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'Application', 'All');
    }


    /**
     * @Route("/", name="_sso_demo_application_show")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('Name', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'Application', 'Show');
    }

    /**
     * @Route("/", name="_sso_demo_application_add")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add($this->buildFormCredentials())
            ->add('Name', 'text')
            ->add('Description', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'Application', 'Add');
    }

    /**
     * @Route("/", name="_sso_demo_application_delete")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add($this->buildFormCredentials())
            ->add('Name', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'Application', 'Delete');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationAll($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        ".$this->xmlCredentials($params)."
                        <Application>
                            <All>
                                <FullResponse>".$params['fullResponse']."</FullResponse>
                            </All>
                        </Application>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationShow($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <Application>
                            <Show>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['Name'] . "</Name>
                                    </ApplicationType>
                                </Key>
                            </Show>
                        </Application>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationAdd($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <Application>
                            <Add>
                                <Value>
                                    <ApplicationType>
                                        <Name>" . $params['Name'] . "</Name>
                                        <Description>" . $params['Description'] . "</Description>
                                    </ApplicationType>
                                </Value>
                            </Add>
                        </Application>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationDelete($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <Application>
                            <Delete>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['Name'] . "</Name>
                                    </ApplicationType>
                                </Key>
                            </Delete>
                        </Application>
                    </SsoRequest>";
    }
}
