<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class ApplicationRoleController
 * @package Sso\DemoBundle\Controller
 */
class ApplicationRoleController extends BaseController
{

    const FORMTYPE_TEXT = "text";
    const CHOICE = "choice";
    const CHOICES = "choices";
    const APIVERSION = "apiVersion";
    const TEXT_NAME = "Name";
    const VERIONONE = "Version 1";

    /**
     * @Route("/", name="_sso_demo_applicationrole_show")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add(static::APIVERSION, static::CHOICE, [static::CHOICES => [1 => static::VERIONONE]])
            ->add(static::TEXT_NAME, static::FORMTYPE_TEXT)
            ->add('ApplicationName', static::FORMTYPE_TEXT)
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'ApplicationRole', 'Show');
    }

    /**
     * @Route("/", name="_sso_demo_applicationrole_add")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add(static::APIVERSION, static::CHOICE, [static::CHOICES => [1 => static::VERIONONE]])
            ->add(static::TEXT_NAME, static::FORMTYPE_TEXT)
            ->add('Description', static::FORMTYPE_TEXT)
            ->add('ApplicationName', static::FORMTYPE_TEXT)
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'ApplicationRole', 'Add');
    }

    /**
     * @Route("/", name="_sso_demo_applicationrole_delete")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add(static::APIVERSION, static::CHOICE, [static::CHOICES => [1 => static::VERIONONE]])
            ->add(static::TEXT_NAME, static::FORMTYPE_TEXT)
            ->add('ApplicationName', static::FORMTYPE_TEXT)
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'ApplicationRole', 'Delete');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationRoleShow($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <ApplicationRole>
                            <Show>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                    </ApplicationType>
                                    <RoleType>
                                        <Name>" . $params[static::TEXT_NAME] . "</Name>
                                    </RoleType>
                                </Key>
                            </Show>
                        </ApplicationRole>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationRoleAdd($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <ApplicationRole>
                            <Add>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                    </ApplicationType>
                                </Key>
                                <Value>
                                    <RoleType>
                                        <Name>" . $params[static::TEXT_NAME] . "</Name>
                                        <Description>" . $params['Description'] . "</Description>
                                    </RoleType>
                                </Value>
                            </Add>
                        </ApplicationRole>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlApplicationRoleDelete($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <ApplicationRole>
                            <Delete>
                                <Key>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                    </ApplicationType>
                                    <RoleType>
                                        <Name>" . $params[static::TEXT_NAME] . "</Name>
                                    </RoleType>
                                </Key>
                            </Delete>
                        </ApplicationRole>
                    </SsoRequest>";
    }
}
