<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class CredentialController
 * @package Sso\DemoBundle\Controller
 */
class CredentialController extends BaseController
{
    /**
     * @Route("/", name="_sso_demo_credential_get")
     * @Template("SsoDemoBundle:Credential:get.html.twig")
     * @param Request $request
     * @return array
     */
    public function getAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('UserUsername', 'text')
            ->add('UserPassword', 'password')
            ->add('get userIdentifier', 'submit')
            ->getForm();

        $form->handleRequest($request);
        $formData = $form->getData();
        if ($form->isValid()) {
            $userUsername = $formData['UserUsername'];
            $userIdentifier = $this->userService()->userIdentifierGet($formData['UserUsername'],
                $formData['UserPassword']);
            $this->sessionVariable('UserIdentifier', $userIdentifier);
            $this->sessionVariable('UserUsername', $userUsername);
        } else {
            $userIdentifier = $this->sessionVariable('UserIdentifier');
            $userUsername = $this->sessionVariable('UserUsername');
        }

        return [
            'userUsername' => $userUsername,
            'userIdentifier' => $userIdentifier,
            'wsRequest' => null,
            'wsResponse' => null,
            'wsProfiler' => null,
            'form' => $form->createView(),
        ];
    }

    /**
     * @return \Sso\Tools\UserIdentifierBundle\Api\ControllerInterface
     */
    public function userService()
    {
        return $this->container->get('sso_tools_user_identifier.api_controller');
    }
}
