<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sso\DemoBundle\Form;

/**
 * Class UserApplicationController
 * @package Sso\DemoBundle\Controller
 */
class UserApplicationController extends BaseController
{

    const TEXT_EMAIL = "Email";
    const TEXT_FORCE = "Force";
    const TEXT_GUID = "Guid";
    const TEXT_USERNAME = "Username";
    const TEXT_IDENTIFIER = "Identifier";
    const TEXT_APPLICATIONNAME = "ApplicationName";
    const TEXT_APPLICATIONACTIVE = "ApplicationActive";
    const FORMTYPE_TEXT = "text";

    /**
     * @Route("/", name="_sso_demo_userapplication_add")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add(static::TEXT_GUID, static::FORMTYPE_TEXT)
            ->add(static::TEXT_EMAIL, static::FORMTYPE_TEXT)
            ->add(static::TEXT_USERNAME, static::FORMTYPE_TEXT)
            ->add(static::TEXT_IDENTIFIER, static::FORMTYPE_TEXT)
            ->add(static::TEXT_APPLICATIONNAME, static::FORMTYPE_TEXT)
            ->add(static::TEXT_APPLICATIONACTIVE, static::FORMTYPE_TEXT)
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplication', 'Add');
    }

    /**
     * @Route("/", name="_sso_demo_userapplication_delete")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add(static::TEXT_GUID, static::FORMTYPE_TEXT)
            ->add(static::TEXT_EMAIL, static::FORMTYPE_TEXT)
            ->add(static::TEXT_USERNAME, static::FORMTYPE_TEXT)
            ->add(static::TEXT_IDENTIFIER, static::FORMTYPE_TEXT)
            ->add(static::TEXT_APPLICATIONNAME, static::FORMTYPE_TEXT)
            ->add(static::TEXT_FORCE, 'integer')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplication', 'Delete');
    }

    /**
     * @Route("/", name="_sso_demo_userapplication_show")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add(static::TEXT_GUID, static::FORMTYPE_TEXT)
            ->add(static::TEXT_EMAIL, static::FORMTYPE_TEXT)
            ->add(static::TEXT_USERNAME, static::FORMTYPE_TEXT)
            ->add(static::TEXT_IDENTIFIER, static::FORMTYPE_TEXT)
            ->add(static::TEXT_APPLICATIONACTIVE, static::FORMTYPE_TEXT)
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplication', 'Show');
    }

    /**
     * @Route("/", name="_sso_demo_userapplication_show_details")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showDetailsAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add('apiVersion', 'choice', [
                'choices' => [
                    1 => 'Version 1',
                    2 => 'Version 2',
                    3 => 'Version 3',
                ],
            ])
            ->add($this->buildFormCredentials())
            ->add(static::TEXT_GUID, static::FORMTYPE_TEXT)
            ->add(static::TEXT_EMAIL, static::FORMTYPE_TEXT)
            ->add(static::TEXT_USERNAME, static::FORMTYPE_TEXT)
            ->add(static::TEXT_IDENTIFIER, static::FORMTYPE_TEXT)
            ->add(static::TEXT_APPLICATIONNAME, 'collection', [
                'type' => new Form\UserApplicationShowDetails(),
                'allow_add' => true,
                'allow_delete' => true,
            ])
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplication', 'ShowDetails');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationAdd($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplication>
                            <Add>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                </Key>
                                <Value>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                        <Active>" . $params['ApplicationActive'] . "</Active>
                                    </ApplicationType>
                                </Value>
                            </Add>
                        </UserApplication>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationShow($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplication>
                            <Show>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                   " . (strlen($params['ApplicationActive']) ? "<ApplicationType><Active>" . $params['ApplicationActive'] . "</Active></ApplicationType>" : "") . "
                                </Key>
                            </Show>
                        </UserApplication>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationShowDetails($params)
    {
        $applicationType = "";
        if (is_array($params['ApplicationName'])) {
            foreach ($params['ApplicationName'] as $appTy) {
                if (!empty($appTy['Name'])) {
                    $applicationType .= "<Name>" . $appTy['Name'] . "</Name>";
                }
            }
        }

        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplication>
                            <ShowDetails>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                   " . (strlen($applicationType) ? "<ApplicationType>" . $applicationType . "</ApplicationType>" : "") . "
                                </Key>
                            </ShowDetails>
                        </UserApplication>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationDelete($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplication>
                            <Delete>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['ApplicationName'] . "</Name>
                                         ".(isset($params['Force']) ? "<Force>".$params['Force']."</Force>" : "")."
                                    </ApplicationType>
                                </Key>
                            </Delete>
                        </UserApplication>
                    </SsoRequest>";
    }
}
