<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sso\DemoBundle\Form;

/**
 * Class UserApplicationRoleController
 * @package Sso\DemoBundle\Controller
 */
class UserApplicationRoleController extends BaseController
{

    /**
     * @Route("/", name="_sso_demo_userapplicationrole_add")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function addAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('Guid', 'text')
            ->add('Email', 'text')
            ->add('Username', 'text')
            ->add('Identifier', 'text')
            ->add('Applicationname', 'text')
            ->add('Rolename', 'text')
            ->add('RoleActive', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplicationRole', 'Add');
    }

    /**
     * @Route("/", name="_sso_demo_userapplicationrole_show")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function showAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1', 2 => 'Version 2']])
            ->add('Guid', 'text')
            ->add('Email', 'text')
            ->add('Username', 'text')
            ->add('Identifier', 'text')
            ->add('Applicationname', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplicationRole', 'Show');
    }

    /**
     * @Route("/", name="_sso_demo_userapplicationrole_delete")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function deleteAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('Guid', 'text')
            ->add('Email', 'text')
            ->add('Username', 'text')
            ->add('Identifier', 'text')
            ->add('Applicationname', 'text')
            ->add('Rolename', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserApplicationRole', 'Delete');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationRoleAdd($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplicationRole>
                            <Add>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['Applicationname'] . "</Name>
                                    </ApplicationType>
                                </Key>
                                <Value>
                                    <RoleType>
                                        <Name>" . $params['Rolename'] . "</Name>
                                         " . (strlen($params['RoleActive']) ? "<Active>" . $params['RoleActive'] . "</Active>" : "") . "
                                    </RoleType>
                                </Value>
                            </Add>
                        </UserApplicationRole>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationRoleShow($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplicationRole>
                            <Show>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['Applicationname'] . "</Name>
                                    </ApplicationType>
                                </Key>
                            </Show>
                        </UserApplicationRole>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserApplicationRoleDelete($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserApplicationRole>
                            <Delete>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                    <ApplicationType>
                                        <Name>" . $params['Applicationname'] . "</Name>
                                    </ApplicationType>
                                    <RoleType>
                                        <Name>" . $params['Rolename'] . "</Name>
                                    </RoleType>
                                </Key>
                            </Delete>
                        </UserApplicationRole>
                    </SsoRequest>";
    }
}
