<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\DemoBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

/**
 * Class UserServiceController
 * @package Sso\DemoBundle\Controller
 */
class UserServiceController extends BaseController
{

    /**
     * @Route("/", name="_sso_demo_userservice_password_request")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function passwordRequestAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('Identifier', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserService', 'PasswordRequest');
    }

    /**
     * @Route("/", name="_sso_demo_userservice_password_confirm")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function passwordConfirmAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('UserKeyDataEmail', 'text')
            ->add('UserKeyDataPasswordToken', 'text')
            ->add('Password', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserService', 'PasswordConfirm');
    }

    /**
     * @Route("/", name="_sso_demo_userservice_activate_request")
     * @Template()
     * @param Request $request
     * @return array
     */
    public function activateRequestAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('Identifier', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserService', 'ActivateRequest');
    }

    /**
     * @Route("/", name="_sso_demo_userservice_activate_confirm")
     * @Template()
     */
    public function activateConfirmAction(Request $request)
    {
        $form = $this->createFormBuilder($this->getFormDefaults())
            ->add($this->buildFormCredentials())
            ->add('apiVersion', 'choice', ['choices' => [1 => 'Version 1']])
            ->add('UserKeyDataEmail', 'text')
            ->add('UserKeyDataActivateToken', 'text')
            ->add('build xml and make webservice request', 'submit')
            ->getForm();

        return $this->getResponseFromForm($form, $request, 'UserService', 'ActivateConfirm');
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserServicePasswordRequest($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserService>
                            <PasswordRequest>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                </Key>
                            </PasswordRequest>
                        </UserService>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserServicePasswordConfirm($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserService>
                            <PasswordConfirm>
                                <Key>
                                    <UserType>
                                        <Email>" . $params['UserKeyDataEmail'] . "</Email>
                                        <PasswordToken>" . $params['UserKeyDataPasswordToken'] . "</PasswordToken>
                                    </UserType>
                                </Key>
                                <Value>
                                    <UserType>
                                        <Password>" . $params['Password'] . "</Password>
                                    </UserType>
                                </Value>
                            </PasswordConfirm>
                        </UserService>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserServiceActivateRequest($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserService>
                            <ActivateRequest>
                                <Key>
                                    <UserType>" . $this->xmlBuildUserIdentifier($params) . "</UserType>
                                </Key>
                            </ActivateRequest>
                        </UserService>
                    </SsoRequest>";
    }

    /**
     * @param array $params
     * @return string
     */
    protected function xmlUserServiceActivateConfirm($params)
    {
        return "<?xml version='1.0'?>
                    <SsoRequest>
                        " . $this->xmlCredentials($params) . "
                        <UserService>
                            <ActivateConfirm>
                                <Key>
                                    <UserType>
                                        <Email>" . $params['UserKeyDataEmail'] . "</Email>
                                        <ActivateToken>" . $params['UserKeyDataActivateToken'] . "</ActivateToken>
                                    </UserType>
                                </Key>
                            </ActivateConfirm>
                        </UserService>
                    </SsoRequest>";
    }
}
