<?php

namespace Sso\DemoBundle\Tests\Controller;

use Sso\DemoBundle\Tests\FunctionalTestCase;

class ApplicationAttributeControllerTest extends FunctionalTestCase
{
    public function testShow()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/application/attribute/show');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("ApplicationAttribute - Show")')->count() > 0);
    }

    public function testAdd()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/application/attribute/add');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("ApplicationAttribute - Add")')->count() > 0);
    }

    public function testDelete()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/application/attribute/delete');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("ApplicationAttribute - Delete")')->count() > 0);
    }

}
