<?php

namespace Sso\DemoBundle\Tests\Controller;

use Sso\DemoBundle\Tests\FunctionalTestCase;

class ApplicationRoleControllerTest extends FunctionalTestCase
{
    public function testShow()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/application/role/show');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("ApplicationRole - Show")')->count() > 0);
    }

    public function testAdd()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/application/role/add');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("ApplicationRole - Add")')->count() > 0);
    }

    public function testDelete()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/application/role/delete');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("ApplicationRole - Delete")')->count() > 0);
    }

}
