<?php

namespace Sso\DemoBundle\Tests\Controller;

use Sso\DemoBundle\Tests\FunctionalTestCase;

class UserControllerTest extends FunctionalTestCase
{
    public function testAdd()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/add');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("User - Add")')->count() > 0);
    }

    public function testShow()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/show');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("User - Show")')->count() > 0);
    }

    public function testDelete()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/delete');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("User - Delete")')->count() > 0);
    }

    public function testUpdate()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/update');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("User - Update")')->count() > 0);
    }

    public function testChangepassword()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/demo/user/changepassword');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("User - Change Password")')->count() > 0);
    }

}
