<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\HelpBundle\Tests\Controller;

use Sso\HelpBundle\Tests\FunctionalTestCase;

/**
 * Class IndexControllerTest
 * @package Sso\HelpBundle\Tests\Controller
 */
class IndexControllerTest extends FunctionalTestCase
{

    public function testIndex()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Sample curl request with php")')->count() > 0);
    }

    public function testApplication()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/application');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Application Show")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Attribute Show")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Attribute Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Attribute Delete")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Role Show")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Role Add")')->count() > 0);
        $this->assertTrue($crawler->filter('html:contains("Application Role Delete")')->count() > 0);
    }

}
