<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\HelpBundle\Tests\Controller;

use Sso\HelpBundle\Tests\FunctionalTestCase;

/**
 * Class TypeControllerTest
 * @package Sso\HelpBundle\Tests\Controller
 */
class TypeControllerTest extends FunctionalTestCase
{
    public function testIndexAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type")')->count() > 0);
    }

    public function testStringAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/string');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type String")')->count() > 0);
    }

    public function testBoolAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/bool');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Bool")')->count() > 0);
    }

    public function testEmailAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/email');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Email")')->count() > 0);
    }

    public function testServiceTokenAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/servicetoken');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Service Token")')->count() > 0);
    }

    public function testServiceNameAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/servicename');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Service Name")')->count() > 0);
    }

    public function testUserIdentifierAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/useridentifier');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Service User Identifier")')->count() > 0);
    }

    public function testServiceCountryCodeAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/servicecountrycode');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Service Country Code")')->count() > 0);
    }

    public function testPasswordAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/password');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Password")')->count() > 0);
    }

    public function testGuidAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/guid');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type GUID")')->count() > 0);
    }

    public function testUsernameAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/username');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Username")')->count() > 0);
    }

    public function testIdentifierAction()
    {
        $client = $this->makeClient(true);

        $crawler = $client->request('GET', '/help/types/identifier');
        $this->assertTrue($client->getResponse()->isSuccessful());
        $this->assertTrue($crawler->filter('html:contains("Data Type Identifier")')->count() > 0);
    }
}
