<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Database;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Database
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter = array();

    /**
     * @var Container
     */
    public $container;


    /**
     * Factory constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return Webservice\Factory
     */
    public function webservice()
    {
        if (!isset($this->facSetter['webservice'])) {
            $this->facSetter['webservice'] = new Webservice\Factory($this->container);
        }

        return $this->facSetter['webservice'];
    }
}
