<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Database\Webservice\Data;

use Symfony\Component\Validator\Validator\RecursiveValidator as Validator;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Database\Webservice\Data
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @var Validator
     */
    protected $validator;

    /**
     * @var boolean
     */
    private $readonly;

    /**
     * @param DoctrineRegistry $doctrineRegistry
     * @param Validator $validator
     * @param boolean $readonly
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, Validator $validator, $readonly)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->validator = $validator;
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
        $this->readonly = $readonly;
    }

    /**
     * @return User\Index
     */
    public function user()
    {
        if (!isset($this->facSetter['user'])) {
            $this->facSetter['user'] = new User\Index($this->doctrineRegistry, $this->validator, $this->readonly);
        }
        return $this->facSetter['user'];
    }
}
