<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Database\Webservice\Data\User;

use Symfony\Component\Validator\Validator\RecursiveValidator as Validator;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;
use Sso\WebserviceBundle\Entity\Webservice\Type\User as EntityUser;
use Doctrine\ORM\EntityRepository;

/**
 * Class Index
 * @package Sso\RestBundle\Api\Database\Webservice\Data\User
 */
class Index
{

    /**
     * Doctrine Registry
     *
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * Validator
     *
     * @var Validator
     */
    protected $validator;

    /**
     * Database in readonly mode
     *
     * @var boolean
     */
    private $readonly;

    /**
     * @param DoctrineRegistry $doctrineRegistry
     * @param Validator $validator
     * @param boolean $readonly
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, Validator $validator, $readonly)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->validator = $validator;
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
        $this->readonly = $readonly;
    }

    /**
     * @param EntityUser $entity
     */
    public function save(EntityUser $entity)
    {
        if (!$this->readonly) {
            $this->entityManager->persist($entity);
            $this->entityManager->flush($entity);
        }
    }

    /**
     * @param EntityUser $entity
     */
    public function delete(EntityUser $entity)
    {
        if (!$this->readonly) {
            $this->entityManager->remove($entity);
            $this->entityManager->flush($entity);
        }
    }

    /**
     * @param string $identifier
     * @return null|object
     */
    public function findUserByIdentifier($identifier)
    {
        // It may be faster, to send up to 3 queries "using const", than doing a full table scan once
        $repository = $this->getUserRepository();
        if (($userGuid = $repository->findOneBy(array('Guid' => $identifier)))) {
            return $userGuid;
        } elseif (($userUsername = $repository->findOneBy(['LowerUsername' => $identifier]))) {
            return $userUsername;
        }
        return $repository->findOneBy(array('LowerEmail' => $identifier));
    }

    /**
     * @return EntityRepository
     */
    private function getUserRepository()
    {
        return $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\Webservice\Type\User', 'Webservice');
    }
}
