<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Database\Webservice;

use Sso\RestBundle\Api\Database\Webservice\Entity;
use Sso\RestBundle\Api\Database\Webservice\Repository;
use Sso\RestBundle\Api\Database\Webservice\Data;

use Symfony\Component\Validator\Validator\ValidatorInterface as Validator;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Database\Webservice
 */
class Factory
{
    /**
     * @var array
     */
    protected $manSetter = array();

    /**
     * @var Container
     */
    protected $container;

    /**
     * Doctrine Registry
     *
     * @var DoctrineRegistry
     */
    protected $doctrineRegistry;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * Validator
     *
     * @var Validator
     */
    protected $validator;

    /**
     * Database in readonly mode
     *
     * @var boolean
     */
    private $readonly;

    /**
     * Factory constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
        $this->doctrineRegistry = $this->container->get('doctrine');
        $this->validator = $this->container->get('validator');
        $this->entityManager = $this->doctrineRegistry->getManager('Webservice');
        $this->readonly = $container->getParameter('database_webservice_readonly');
    }

    /**
     * @return Repository\Factory
     */
    public function respository()
    {
        if (!isset($this->manSetter['respository'])) {
            $this->manSetter['respository'] = new Repository\Factory($this->entityManager);
        }
        return $this->manSetter['respository'];
    }

    /**
     * @return Entity\Factory
     */
    public function entity()
    {
        if (!isset($this->manSetter['entity'])) {
            $this->manSetter['entity'] = new Entity\Factory();
        }
        return $this->manSetter['entity'];
    }

    /**
     * @return Data\Factory
     */
    public function data()
    {
        if (!isset($this->manSetter['data'])) {
            $this->manSetter['data'] = new Data\Factory($this->doctrineRegistry, $this->validator, $this->readonly);
        }
        return $this->manSetter['data'];
    }

    /**
     * @return EntityManager
     */
    public function entityManager()
    {
        return $this->entityManager;
    }
}
