<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Database\Webservice\Repository;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityRepository;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Database\Webservice\Repository
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @var EntityManager
     */
    protected $entityManager;

    /**
     * @param EntityManager $entityManager
     */
    public function __construct(EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    /**
     * @return EntityRepository
     */
    public function user()
    {
        if (!isset($this->facSetter['user'])) {
            $this->facSetter['user'] = $this->entityManager->getRepository('Sso\WebserviceBundle\Entity\Webservice\Type\User',
                'Webservice');
        }
        return $this->facSetter['user'];
    }
}
